<?php
/* --------------------------------------------------------------
   GambioHubOtPaypal3Instfee.inc.php 2019-04-08
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

class GambioHubOtPaypal3Instfee extends GambioHubOtPaypal3Instfee_parent
{
    public function process()
    {
        if ($_SESSION['payment'] === 'gambio_hub'
            && $_SESSION['gambio_hub_selection'] === 'PayPal2InstallmentsHub'
            && !empty($_SESSION['paypal_payment_installments'])
        ) {
            $xtPrice    = $GLOBALS['xtPrice'];
            $fee        = $_SESSION['paypal_payment_installments']['total_interest'];
            $totalTotal = $_SESSION['paypal_payment_installments']['total_cost'];
    
            $this->output[] = [
                'title' => '<br>' . constant($this->getConfigurationKey('FEE_TITLE')) . ':',
                'text'  => '<br>' . $xtPrice->xtcFormat($fee, true),
                'value' => $xtPrice->xtcFormat($fee, false),
            ];
    
            $this->output[] = [
                'title' => sprintf('<b>%s:</b>', constant($this->getConfigurationKey('TITLE'))),
                'text'  => sprintf('<b>%s</b>', $xtPrice->xtcFormat($totalTotal, true)),
                'value' => $xtPrice->xtcFormat($totalTotal, false),
            ];
        } else {
            parent::process();
        }
    }
}
